;;
;;  explan.lsp - Express Tools plan replacement command
;;                    
;;
;;  Copyright  1999 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;  DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;  UNINTERRUPTED OR ERROR FREE.
;;
;;
;; Description:
;;  Similar to PLAN except that EXPLAN automatically zooms to the center 
;; of the extents of selected objects after performing a plan view to
;; the specified ucs. i.e. In other words; it keeps the zoom distance 
;; consistant.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
(defun c:explan ( / ss c s lst d )
 (acet-error-init 
   (list '( "cmdecho" 0
            "ucsicon" nil
          ) 
         1
         '(setq ACET:UCS-LIST nil)
   );list
 )
 (setq s (getvar "viewsize"))
 (princ "\nSelect objects to zoom to or press <enter> to select everything on screen...")
 (if (and (setq ss (ssget))
          (setq c (acet-geom-ss-extents ss nil))
     );and
     (setq c (acet-geom-midpoint (car c) (cadr c)));setq then
     (progn
      (setq lst (acet-explan-view-extents)
            lst (acet-geom-m-trans lst 0 1)
            lst (acet-geom-cube-points lst)
            lst (acet-geom-list-extents lst)
              c (acet-geom-midpoint (car lst) (cadr lst))
              d (distance (car lst) (cadr lst))
      );setq
      (if (> d s)
          (setq s (/ (+ d s) 2.0));then use the average of the two
      );if
      ;(command "_.line" c pause "")
     );progn else
 );if
 (princ "\nEnter an option [Current ucs/Ucs/World] <Current>: ")
 (command "_.plan")
 (setvar "cmdecho" 1)
 (while (wcmatch (getvar "cmdnames") "*PLAN*")
  (command pause)
 );while
 (setvar "cmdecho" 0)
 (if c
     (command "_.zoom" "_c" c s)
 );if
 (acet-error-restore)
);defun c:explan
 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Selects everything  on screen and uses the extents of that combined with the screen 
;corcer points to determine the center point (wcs) to use for the zoom after the plan 
;command.
;Returns list of points in wcs
;
(defun acet-explan-view-extents ( / ss p1 p2 p3 p4 lst px )
 (princ "\nSelecting objects on screen...")
 (acet-sysvar-set (list "ucsicon" 0))
 (acet-ucs-cmd (list "_view"))
 (setq  p1 (acet-geom-view-points)
        p2 (cadr p1)
        p1 (car p1)
        px (acet-geom-pixel-unit)
        p1 (list (+ (car p1) px)
                 (+ (cadr p1) px)
                 (caddr p1)
           )
        p2 (list (- (car p2) px)
                 (- (cadr p2) px)
                 (caddr p2)
           )
 );setq
 (if (or (setq ss (ssget "_w" p1 p2))
         (setq ss (ssget "_c" p1 p2))
     );or
     (setq p3 (acet-geom-ss-extents ss nil) ;no shrinkwrap
           p4 (cadr p3)
           p3 (car p3)
           p1 (list (car p1)		;; combine the view extents xy with extents of objects in z
                    (cadr p1)
                    (min (caddr p3) (caddr p4))
              )
           p2 (list (car p2)
                    (cadr p2)
                    (max (caddr p3) (caddr p4))
              )
     );setq then
 );if
 (setq lst (acet-geom-cube-points (list p1 p2)) ;generate the remaining points based on lower left and upper right
       lst (acet-geom-m-trans lst 1 0)
 );setq
 (acet-ucs-cmd (list "_previous"))
 (acet-sysvar-restore)
 (princ "Done")
 lst
);defun acet-explan-view-extents
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Returns a list of 8 points 4 top and 4 bottom.
;
(defun acet-geom-cube-points ( lst / p1 p2 z1 z2 )
 (setq lst (acet-geom-list-extents lst)
        p1 (car lst)
        p2 (cadr lst)
        z1 (min (caddr p1) (caddr p2))
        z2 (max (caddr p1) (caddr p2))
 );setq
 (list (list (car p1) (cadr p1) z1)
       (list (car p2) (cadr p1) z1)
       (list (car p2) (cadr p2) z1)
       (list (car p1) (cadr p2) z1)
       (list (car p1) (cadr p1) z2)
       (list (car p2) (cadr p1) z2)
       (list (car p2) (cadr p2) z2)
       (list (car p1) (cadr p2) z2)
 );list
);defun acet-geom-cube-points


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; cQcAADCCB20GCSqGSIb3DQEHAqCCB14wggdaAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIFBzCCBQMwggProAMCAQICEHZytCYU0up+ZBBTpYM4hJYw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTYwODA4MDAwMDAwWhcNMTcwOTAyMjM1OTU5WjCBiDELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FjAUBgNVBAoMDUF1dG9kZXNrLCBJbmMxHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlv
;;; bnMgR3JvdXAxFjAUBgNVBAMMDUF1dG9kZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEB
;;; AQUAA4IBDwAwggEKAoIBAQDqmfToz8wEanfXT+H6tql3aUyaJRWCfFsYPFnGVXIl
;;; 95fnZY3sOEfQvFkf9LVte5SwDWkjkReCGJlk4HaRYOTxkd7PkeAOOtYaUSBvULYR
;;; lKvAbe2n+VWwo4yrWATav8d7pKlbMP9f6pYxlaZQzsq/e+pLZwptP8C9Dfrm5OVg
;;; CIL/iPRNIuvhl9YUZvnkZYmCnihdP4AS8g4d7rfjdxzT653433nO6tgs3fNgnkQQ
;;; k6EdROwqesgQXRlH29yRND5xNfup9KiZ7L7Nm7AiM6laNwNIjBwbG4qMWuQ2Ml7h
;;; HzQpLaLFJRV33oHedeGSZ7OmA6+D5WoQtPpSt4YCcub5AgMBAAGjggFpMIIBZTAJ
;;; BgNVHRMEAjAAMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBh
;;; BgNVHSAEWjBYMFYGBmeBDAEEATBMMCMGCCsGAQUFBwIBFhdodHRwczovL2Quc3lt
;;; Y2IuY29tL2NwczAlBggrBgEFBQcCAjAZDBdodHRwczovL2Quc3ltY2IuY29tL3Jw
;;; YTAfBgNVHSMEGDAWgBTUwAYiSes5S92T4lyhuEd2CXIDWDArBgNVHR8EJDAiMCCg
;;; HqAchhpodHRwOi8vcmIuc3ltY2IuY29tL3JiLmNybDBXBggrBgEFBQcBAQRLMEkw
;;; HwYIKwYBBQUHMAGGE2h0dHA6Ly9yYi5zeW1jZC5jb20wJgYIKwYBBQUHMAKGGmh0
;;; dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3J0MBEGCWCGSAGG+EIBAQQEAwIEEDAWBgor
;;; BgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0BAQsFAAOCAQEAwDtvZOfelquc
;;; pqTk6GC5mkXO2Xhr2Meo+ZTVpsAgvQAi0zfpqlxdZrH+SrR0R06cixVQx/8wgty6
;;; 0cx0h7n5YZChZYSULBLbWd64ZisZRLSfOSHfaQPMJlzfkObSiErUXli7GdngNeRv
;;; QRBZj76uQwBY9IfizReoavOwtm1aoptvSn/cAzKdzXXe4Y9O0BFYewqgihKACWL1
;;; 0QQQHazE6owk7WAsA5AGgIOS3RJucO+owkJEdl8yjk4A5amvbkCMkAQHNnIul/Tg
;;; XRicNGTNCQ5RJEaa97jg7WSDp1EEHISPpPnMBACu/rxYX7CwYuw8rdZm73yDa/NN
;;; 3BY2t4uSTjGCAiowggImAgEBMIGZMIGEMQswCQYDVQQGEwJVUzEdMBsGA1UEChMU
;;; U3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5l
;;; dHdvcmsxNTAzBgNVBAMTLFN5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
;;; bmluZyBDQSAtIEcyAhB2crQmFNLqfmQQU6WDOISWMA0GCSqGSIb3DQEBCwUAMA0G
;;; CSqGSIb3DQEBAQUABIIBALNVGWfJhQ3S3BTjyzJAKGS+DoyCOTtN36kKzVZZnp2g
;;; Hu+ZWgW47VZDFiDU0MmEaXgYruLdG20vlna/rTvvKrMz7yrXM9f5wiIVTSg6aJMb
;;; K9gC/DxiPYpG71ZWMdVHP/qXJCT6eksFoIL7M7VOyVy4IBAge8dvC9sljyeHg1BJ
;;; Hgs52V0RP3roRbvjIjaDm7jjJaKc34gsQKKJ25SmGt2v2C7QUEPwuoFagAyHCO6h
;;; h6VhjFcFxJ32kKbvwHBqxv954zeoNRW5M9WDDguRbigELjkgvw7rzdvB5Mlmy7Wy
;;; H5j9XOf51REp9+lefjgIIW/ZWSJzR2YCp6l3IWzN5EehYzBhBgNVHQ4xWgRYNAAw
;;; ADsAMgAvADMALwAyADAAMQA3AC8ANAAvADUAMAAvADQAOAAvAFQAaQBtAGUAIABm
;;; AHIAbwBtACAAdABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----